<?php
/**
 * Lector de rol del usuario desde inscripcion_cursos
 * Lee el rol del usuario activo desde la tabla inscripcion_cursos
 * Se debe incluir después de session_start.php y conexion.php
 */

// Verificar que la sesión esté activa
if (!isset($_SESSION['id']) || empty($_SESSION['id'])) {
    // Si no hay sesión, asignar rol de estudiante por defecto
    $_SESSION['rol'] = 0;
    return;
}

$usuarioId = (int)$_SESSION['id'];

try {
    // Buscar el primer curso donde el usuario tenga un rol asignado (no NULL)
    $stmt = $dsn->prepare("SELECT c001, c002, c003, c004, c005, c006, c007, c008, c009, c010 FROM inscripcion_cursos WHERE id = ?");
    $stmt->execute([$usuarioId]);
    $roles = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($roles) {
        // Buscar el primer rol no NULL
        $rolUsuario = NULL;
        foreach ($roles as $columna => $valor) {
            if ($valor !== NULL) {
                $rolUsuario = $valor;
                break;
            }
        }
        
        // Si no encontró rol, asignar estudiante por defecto
        if ($rolUsuario === NULL) {
            $rolUsuario = 0; // Estudiante por defecto
        }
        
        $_SESSION['rol'] = $rolUsuario;
    } else {
        // Si no hay registro en inscripcion_cursos, asignar estudiante por defecto
        $_SESSION['rol'] = 0;
    }
    
} catch (Exception $e) {
    // En caso de error, asignar estudiante por defecto
    $_SESSION['rol'] = 0;
    error_log("Error en leer_rol.php: " . $e->getMessage());
}

// Si no existe el rol en la sesión, asumir estudiante por defecto
if (!isset($_SESSION['rol'])) {
    $_SESSION['rol'] = 0; // Asignar rol de estudiante por defecto (0)
}
?>