<?php
/**
 * Lector de roles de inscripción de cursos - Lee roles del usuario en cada curso
 * Lee el rol del usuario en cada curso desde la base de datos
 * Solo lee las columnas de cursos que están configurados en configuracion_cursos.php
 */

/** 1) Validación de sesión y configuración **********************************************/

// Verificar que la sesión esté activa
if (!isset($_SESSION['id']) || empty($_SESSION['id'])) {
    die("Error: Sesión no válida. Por favor, inicie sesión nuevamente.");
}

$usuarioId = (int)$_SESSION['id'];   // id del usuario logueado

// Cargar configuración de cursos para determinar qué columnas leer
if (!isset($cursos) || empty($cursos)) {
    die("Error: No se pudo cargar la configuración de cursos.");
}

// ── Construye la lista de columnas dinámicamente basándose en configuracion_cursos.php ──
$columnas = [];
foreach ($cursos as $codigoCurso => $datoCurso) {
    $columnas[] = $codigoCurso; // c001, c002, c003, etc.
}
$listaColumnas = implode(', ', $columnas);

/** 2) Conexión y consulta a la base de datos **********************************************/

try {
    // ── Prepara y ejecuta la consulta ──
    $sql = "SELECT $listaColumnas FROM inscripcion_cursos WHERE id = :id";
    $stmt = $dsn->prepare($sql);
    $stmt->bindValue(':id', $usuarioId, PDO::PARAM_INT);
    $stmt->execute();

    /** 3) Procesa el resultado **********************************************/
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$resultado) {
        throw new Exception("No se encontró registro en inscripcion_cursos para el usuario $usuarioId");
    }

    // ── Convertir a array numérico ordenado para facilitar el procesamiento ──
    $valoresC = [];                 // Índices 0-N con los roles del usuario en cada curso
    foreach ($columnas as $col) {
        $valoresC[] = isset($resultado[$col]) ? $resultado[$col] : NULL; // Mantener NULL si no existe
    }

} catch (Exception $e) {
    // Manejo de errores
    error_log("Error en lectura_inscripcion_cursos.php: " . $e->getMessage());
    die("Error al leer los cursos: " . $e->getMessage());
}

/** 4) Variables disponibles para uso posterior **********************************************/

// $valoresC - Array numérico con roles [NULL, 0, 1, 2, 3, 4, ...]
//             NULL = Usuario NO tiene rol asignado en ese curso
//             0 = Usuario tiene rol de Estudiante en ese curso
//             1 = Usuario tiene rol de Profesor en ese curso
//             2 = Usuario tiene rol de Revisor en ese curso
//             3 = Usuario tiene rol de Observador en ese curso
//             4 = Usuario tiene rol de Administrador en ese curso
//             El índice corresponde al orden de los cursos en configuracion_cursos.php

?>