<?php
header('Content-Type: application/json');

// Permitir CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

// Logging para debug
error_log("Verificando archivo: " . ($_GET['archivo'] ?? 'no especificado'));

// Obtener el archivo a verificar
$archivo = $_GET['archivo'] ?? '';

if (empty($archivo)) {
    echo json_encode(['error' => 'No se especificó archivo a verificar']);
    exit;
}

// Lista de archivos permitidos para verificar
$archivosPermitidos = [
    'index.html',
    'general.css', 
    'index.css',
    'login.html',
    'login.css',
    'config.php',
    'conexion.php',
    'login.php',
    'session_start.php',
    'menu.php',
    'menu.css',
    'header.css',
    'logout.php',
    // Archivos dentro de generador_de_archivos
    'crear_index.html',
    'crear_login.html',
    'guardar_index.php',
    'ayuda.php'
];

// Verificar si el archivo está en la lista permitida
if (!in_array($archivo, $archivosPermitidos)) {
    echo json_encode(['error' => 'Archivo no permitido: ' . $archivo]);
    exit;
}

// Construir la ruta del archivo
$archivosEnCarpetaActual = ['crear_index.html', 'crear_login.html', 'guardar_index.php', 'ayuda.php'];

if (in_array($archivo, $archivosEnCarpetaActual)) {
    // Archivos en la carpeta actual (generador_de_archivos)
    $rutaArchivo = $archivo;
} else {
    // Archivos en el directorio padre
    $rutaArchivo = '../' . $archivo;
}

// Verificar si el archivo existe
$existe = file_exists($rutaArchivo);

// Obtener información adicional del archivo
$info = [];
if ($existe) {
    $info = [
        'existe' => true,
        'tamaño' => filesize($rutaArchivo),
        'fecha_modificacion' => date('Y-m-d H:i:s', filemtime($rutaArchivo)),
        'ruta' => $rutaArchivo
    ];
} else {
    $info = [
        'existe' => false,
        'ruta_buscada' => $rutaArchivo
    ];
}

echo json_encode($info);
?> 