<?php
/**
 * Guardador del archivo crear_tabla_inscripcion_cursos.sql
 * Guarda el script SQL para crear la tabla de inscripción de cursos
 */

// Verificar que se recibió el contenido
if (!isset($_POST['sqlContent']) || empty($_POST['sqlContent'])) {
    echo "Error: No se recibió contenido SQL para guardar";
    exit;
}

$sqlContent = $_POST['sqlContent'];

// Ruta donde guardar el archivo
$archivo = '../crear_tabla_inscripcion_cursos.sql';

// Crear backup del archivo existente si existe
if (file_exists($archivo)) {
    $backup = $archivo . '.backup.' . date('Y-m-d_H-i-s');
    if (!copy($archivo, $backup)) {
        echo "Error: No se pudo crear backup del archivo existente";
        exit;
    }
}

// Intentar guardar el archivo
$resultado = file_put_contents($archivo, $sqlContent);

if ($resultado === false) {
    echo "Error: No se pudo guardar el archivo crear_tabla_inscripcion_cursos.sql";
    exit;
}

// Verificar que el archivo se guardó correctamente
if (!file_exists($archivo)) {
    echo "Error: El archivo no se creó correctamente";
    exit;
}

// Obtener información del archivo guardado
$tamano = filesize($archivo);
$modificado = date('Y-m-d H:i:s', filemtime($archivo));

// Respuesta de éxito
echo "success: Archivo crear_tabla_inscripcion_cursos.sql guardado exitosamente\n";
echo "Tamaño: $tamano bytes\n";
echo "Modificado: $modificado\n";

if (isset($backup)) {
    echo "Backup creado: " . basename($backup) . "\n";
}
?> 