<?php
// Archivo para guardar el contenido CSS como login.css

// Verificar que sea una petición POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo 'error: Método no permitido';
    exit;
}

// Verificar que se haya enviado el contenido CSS
if (!isset($_POST['cssContent']) || empty($_POST['cssContent'])) {
    http_response_code(400);
    echo 'error: No se recibió contenido CSS';
    exit;
}

// Obtener el contenido CSS
$cssContent = $_POST['cssContent'];

// Validar que el contenido no esté vacío
if (trim($cssContent) === '') {
    http_response_code(400);
    echo 'error: El contenido CSS está vacío';
    exit;
}

// Intentar guardar el archivo
try {
    $filePath = '../login.css';
    $result = file_put_contents($filePath, $cssContent);
    
    if ($result === false) {
        http_response_code(500);
        echo 'error: No se pudo guardar el archivo en ' . $filePath . '. Verifica los permisos de escritura.';
        exit;
    }
    
    // Éxito
    echo 'success: Archivo login.css guardado exitosamente en ' . $filePath;
    
} catch (Exception $e) {
    http_response_code(500);
    echo 'error: Error al guardar el archivo: ' . $e->getMessage();
    exit;
}
?> 