<?php
// Archivo para guardar el contenido CSS como general.css

// Verificar que sea una petición POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo 'error: Método no permitido';
    exit;
}

// Verificar que se haya enviado el contenido CSS
if (!isset($_POST['cssContent']) || empty($_POST['cssContent'])) {
    http_response_code(400);
    echo 'error: No se recibió contenido CSS';
    exit;
}

// Obtener el contenido CSS
$cssContent = $_POST['cssContent'];

// Validar que el contenido sea CSS válido
if (strpos($cssContent, '/*') === false && strpos($cssContent, '{') === false) {
    http_response_code(400);
    echo 'error: El contenido no parece ser CSS válido';
    exit;
}

// Intentar guardar el archivo
try {
    $result = file_put_contents('../general.css', $cssContent);
    
    if ($result === false) {
        http_response_code(500);
        echo 'error: No se pudo guardar el archivo. Verifica los permisos de escritura.';
        exit;
    }
    
    // Éxito
    echo 'success: Archivo general.css guardado exitosamente';
    
} catch (Exception $e) {
    http_response_code(500);
    echo 'error: Error al guardar el archivo: ' . $e->getMessage();
    exit;
}
?> 