<?php
// Configurar headers para CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// Verificar que sea una petición POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo 'Método no permitido';
    exit();
}

// Obtener los datos del POST
$codigoInterno = $_POST['codigoInterno'] ?? '';
$imagenBase64 = $_POST['imagenBase64'] ?? '';

if (empty($codigoInterno) || empty($imagenBase64)) {
    http_response_code(400);
    echo 'Error: Faltan datos requeridos';
    exit();
}

// Crear directorio de imágenes si no existe
$directorioImagenes = '../imagenes_cursos/';
if (!is_dir($directorioImagenes)) {
    mkdir($directorioImagenes, 0755, true);
}

// Generar nombre del archivo
$nombreArchivo = 'img_' . $codigoInterno . '.jpg';
$rutaCompleta = $directorioImagenes . $nombreArchivo;

try {
    // Decodificar imagen base64
    $imagenData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $imagenBase64));
    
    if ($imagenData === false) {
        throw new Exception('Error al decodificar la imagen base64');
    }
    
    // Guardar la imagen
    $resultado = file_put_contents($rutaCompleta, $imagenData);
    
    if ($resultado === false) {
        throw new Exception('No se pudo guardar la imagen');
    }
    
    // Verificar que el archivo se guardó correctamente
    if (!file_exists($rutaCompleta)) {
        throw new Exception('El archivo no se creó correctamente');
    }
    
    // Retornar la ruta relativa de la imagen
    $rutaRelativa = 'imagenes_cursos/' . $nombreArchivo;
    
    echo json_encode([
        'success' => true,
        'ruta' => $rutaRelativa,
        'mensaje' => 'Imagen guardada correctamente'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?> 