<?php
session_start();
header('Content-Type: application/json');

// Verificar que el usuario esté logueado
if (!isset($_SESSION['id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Usuario no autenticado']);
    exit();
}

require_once '../conexion.php';

$curso = $_GET['curso'] ?? '';
$unidad = $_GET['unidad'] ?? '';
$actividad = $_GET['actividad'] ?? '';

if (empty($curso) || empty($unidad) || empty($actividad)) {
    echo json_encode(['success' => false, 'message' => 'Parámetros faltantes']);
    exit();
}

// Normalizar formato de unidad
if (preg_match('/Unidad (\d+)/', $unidad, $matches)) {
    $unidad = str_pad($matches[1], 2, '0', STR_PAD_LEFT);
} else {
    $unidad = str_pad($unidad, 2, '0', STR_PAD_LEFT);
}

$actividad_padded = str_pad($actividad, 2, '0', STR_PAD_LEFT);
$usuario_id = $_SESSION['id'];

try {
    $tabla = "avance_{$curso}_u{$unidad}";
    
    // Obtener valores de las variables de la ruta
    $sql = "SELECT 
                NIVACT{$actividad_padded} as nivel,
                PJEACT{$actividad_padded} as puntos,
                INTACT{$actividad_padded} as intentos,
                ACT{$actividad_padded} as completada
            FROM `{$tabla}` 
            WHERE id = :usuario_id";
    
    $stmt = $dsn->prepare($sql);
    $stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$resultado) {
        // Si no existe el registro, crear uno con valores por defecto
        $sql_insert = "INSERT INTO `{$tabla}` (id, NIVACT{$actividad_padded}, PJEACT{$actividad_padded}, INTACT{$actividad_padded}, ACT{$actividad_padded}) 
                       VALUES (:usuario_id, 0, 0, 0, 0)";
        $stmt_insert = $dsn->prepare($sql_insert);
        $stmt_insert->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
        $stmt_insert->execute();
        
        $resultado = [
            'nivel' => 0,
            'puntos' => 0,
            'intentos' => 0,
            'completada' => 0
        ];
    }
    
    // Convertir valores NULL a 0
    $nivel = $resultado['nivel'] ?? 0;
    $puntos = $resultado['puntos'] ?? 0;
    $intentos = $resultado['intentos'] ?? 0;
    $completada = $resultado['completada'] ?? 0;
    
    // Calcular estrellas basado en el nivel
    $estrellas = $nivel;
    
    // Determinar nivel actual (1-3)
    $nivelActual = min($nivel + 1, 3);
    
    echo json_encode([
        'success' => true,
        'data' => [
            'estrellas' => $estrellas,
            'nivel' => $nivel,
            'nivelActual' => $nivelActual,
            'puntos' => $puntos,
            'intentos' => $intentos,
            'completada' => $completada
        ]
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error de base de datos: ' . $e->getMessage()
    ]);
    error_log("Error en obtener_estado_ruta.php: " . $e->getMessage());
}
?>
