<?php
session_start();
header('Content-Type: application/json');

require_once '../config.php';
require_once '../conexion.php';

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $numeroActividad = isset($input['numeroActividad']) ? $input['numeroActividad'] : null;
    $variable = isset($input['variable']) ? $input['variable'] : '';
    
    if (!$numeroActividad) {
        throw new Exception('Número de actividad requerido');
    }
    
    // Obtener curso y unidad desde los parámetros o sesión
    $curso = isset($_GET['curso']) ? $_GET['curso'] : '';
    $unidad = isset($_GET['unidad']) ? $_GET['unidad'] : '';
    
    if (empty($curso) || empty($unidad)) {
        throw new Exception('Curso y unidad requeridos');
    }
    
    // Normalizar unidad (convertir "Unidad 01" a "01")
    if (preg_match('/Unidad (\d+)/i', $unidad, $matches)) {
        $unidad_normalizada = str_pad($matches[1], 2, '0', STR_PAD_LEFT);
    } else {
        $unidad_normalizada = str_pad($unidad, 2, '0', STR_PAD_LEFT);
    }
    
    // Construir el nombre de la tabla
    $nombre_tabla = 'avance_' . $curso . '_u' . $unidad_normalizada;
    
    // Construir el nombre de la columna ACT##
    $actividad_padded = str_pad($numeroActividad, 2, '0', STR_PAD_LEFT);
    $columna_act = 'ACT' . $actividad_padded;
    
    // Obtener el ID del usuario actual
    $usuario_id = $_SESSION['id'] ?? null;
    if (!$usuario_id) {
        throw new Exception('Usuario no autenticado');
    }
    
    // Verificar que la tabla existe
    $stmt = $dsn->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = :tabla");
    $stmt->bindParam(':tabla', $nombre_tabla, PDO::PARAM_STR);
    $stmt->execute();
    $existe = $stmt->fetchColumn();
    
    if (!$existe) {
        throw new Exception('La tabla no existe');
    }
    
    // Actualizar la columna ACT## a 1
    $sql = "UPDATE `{$nombre_tabla}` SET `{$columna_act}` = 1 WHERE id = :usuario_id";
    $stmt = $dsn->prepare($sql);
    $stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmt->execute();
    
    echo json_encode([
        'success' => true,
        'message' => 'Actividad marcada como completada',
        'actividad' => $columna_act,
        'usuario_id' => $usuario_id
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
