<?php
session_start();
header('Content-Type: application/json');

// Verificar que el usuario esté logueado
if (!isset($_SESSION['id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Usuario no autenticado']);
    exit();
}

require_once '../conexion.php';

$input = json_decode(file_get_contents('php://input'), true);

$curso = $input['curso'] ?? '';
$unidad = $input['unidad'] ?? '';
$actividad = $input['actividad'] ?? '';
$estrellas = $input['estrellas'] ?? 0;
$puntos = $input['puntos'] ?? 0;
$nivel = $input['nivel'] ?? 0;
$intentos = $input['intentos'] ?? 0;

if (empty($curso) || empty($unidad) || empty($actividad)) {
    echo json_encode(['success' => false, 'message' => 'Parámetros faltantes']);
    exit();
}

// Normalizar formato de unidad
if (preg_match('/Unidad (\d+)/', $unidad, $matches)) {
    $unidad = str_pad($matches[1], 2, '0', STR_PAD_LEFT);
} else {
    $unidad = str_pad($unidad, 2, '0', STR_PAD_LEFT);
}

$actividad_padded = str_pad($actividad, 2, '0', STR_PAD_LEFT);
$usuario_id = $_SESSION['id'];

try {
    $tabla = "avance_{$curso}_u{$unidad}";
    
    // Actualizar o insertar el estado del usuario
    // IMPORTANTE: Se guarda 'estrellas' en NIVACT, no 'nivel' (currentLevel)
    // ACT04 = 1 cuando NIVACT04 = 2 (alcanzó el nivel avanzado)
    $act_completada = ($estrellas >= 2) ? 1 : 0;
    
    $sql = "INSERT INTO `{$tabla}` (id, NIVACT{$actividad_padded}, PJEACT{$actividad_padded}, INTACT{$actividad_padded}, ACT{$actividad_padded}) 
            VALUES (:usuario_id, :estrellas, :puntos, :intentos, :act_completada)
            ON DUPLICATE KEY UPDATE 
            NIVACT{$actividad_padded} = :estrellas,
            PJEACT{$actividad_padded} = :puntos,
            INTACT{$actividad_padded} = :intentos,
            ACT{$actividad_padded} = :act_completada";
    
    $stmt = $dsn->prepare($sql);
    $stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmt->bindParam(':estrellas', $estrellas, PDO::PARAM_INT);
    $stmt->bindParam(':puntos', $puntos, PDO::PARAM_INT);
    $stmt->bindParam(':intentos', $intentos, PDO::PARAM_INT);
    $stmt->bindParam(':act_completada', $act_completada, PDO::PARAM_INT);
    $stmt->execute();
    
    echo json_encode([
        'success' => true,
        'message' => 'Estado actualizado correctamente'
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error de base de datos: ' . $e->getMessage()
    ]);
    error_log("Error en actualizar_estado_ruta.php: " . $e->getMessage());
}
?>
